// IOCTLS.H -- IOCTL code definitions for Arb5600 driver
// Copyright (C) 1999, 2000 by Walter Oney
// All rights reserved
#ifndef IOCTLS_H
#define IOCTLS_H

#ifndef CTL_CODE
#pragma message("CTL_CODE undefined. Include winioctl.h or wdm.h")
#endif

#if 0
#define ARBIOC_IOR_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_IOR_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_IOR_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_IOW_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_IOW_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_IOW_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ARBIOC_MMR_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x810, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_MMR_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x811, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_MMR_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x812, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_MMW_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_MMW_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_MMW_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ARBIOC_CFR_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x820, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_CFR_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x821, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_CFR_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x822, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_CFW_BYTE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x823, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_CFW_WORD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x824, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_CFW_DWRD  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x825, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ARBIOC_GET_CONT  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x830, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GET_BUFF  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x831, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GET_MEMSIZE   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x832, METHOD_BUFFERED, FILE_READ_ACCESS)

//ARBIO IOCTL COMMAND for portio
#define ARBIOC_GIOR_BYTE		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x840, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GIOR_WORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x841, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GIOR_DWORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x842, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GIOW_BYTE		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x843, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_GIOW_WORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x844, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_GIOW_DWORD 	CTL_CODE(FILE_DEVICE_UNKNOWN, 0x845, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ARBIOC_GMMR_BYTE		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x850, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GMMR_WORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x851, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GMMR_DWORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x852, METHOD_BUFFERED, FILE_READ_ACCESS)
#define ARBIOC_GMMW_BYTE		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x853, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_GMMW_WORD		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x854, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_GMMW_DWORD 	CTL_CODE(FILE_DEVICE_UNKNOWN, 0x855, METHOD_BUFFERED, FILE_ANY_ACCESS)
#endif

#if 0
typedef struct _IO_ACCESS
{
	unsigned long offset;    //IO OFFSET SET ADDRESS OR SIZE  1 = BYTE , 2 = WORD , 4 = DWORD
	union
	{
		u8  byte;   			   //DATA BYTE	
		u16 word;				     //DATA WORD
		u32 dword;				   //DATA DWORD	
	} value;
} IO_ACCESS;


/**
---------- IOCTL Configure targets */

# define CONF_ACC   	0	/* mask and code */
# define CONF_ACCM   	1	/* mask only */
# define CONF_ACCC   	2	/* code only */

# define CONF_OMODE 	4	/* output control register */
# define CONF_FILTER	5
# define CONF_FENABLE	6
# define CONF_FDISABLE	7
# define CONF_LISTEN_ONLY_MODE	8	/* for SJA1000 PeliCAN */
# define CONF_SELF_RECEPTION	9	/* */
# define CONF_BTR   		10      /* set direct bit timing registers (SJA1000) */
# define CONF_TIMESTAMP  	11      /* use TS in received messages */
# define CONF_WAKEUP		12      /* wake up processes *///End of CANBUS
#endif

#endif // for 'ifndef IOCTLS_H'

/**
---------- IOCTL Command subcommands and there targets */
# define CMD_START		1
# define CMD_STOP 		2
//# define CMD_RESET		3
//# define CMD_CLEARBUFFERS	4

//CAN BUS IOCTL CMMAND
#define ARBIOC_CAN_COMMAND  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x860, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ARBIOC_CAN_CONFIG 	CTL_CODE(FILE_DEVICE_UNKNOWN, 0x861, METHOD_BUFFERED, FILE_ANY_ACCESS)
//#define ARBIOC_CAN_SEND 		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x862, METHOD_BUFFERED, FILE_ANY_ACCESS)
//#define ARBIOC_CAN_CONFIGURERTR CTL_CODE(FILE_DEVICE_UNKNOWN, 0x863, METHOD_BUFFERED, FILE_ANY_ACCESS)
//#define ARBIOC_CAN_STATUS   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x864, METHOD_BUFFERED, FILE_ANY_ACCESS)

# define CONF_TIMING	3	/* bit timing */
