// SC2A0Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SC2A0.h"
#include "SC2A0Dlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID SC2A0_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[SC2A0] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 8, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

/////////////////////////////////////////////////////////////////////////////
// CSC2A0Dlg dialog

CRect g_rect_channel_window_topology_01_704[ 1 ] = { CRect(       0,       0,       704,       480 )  // FULLSCREEN
};
CRect g_rect_channel_window_topology_04_704[ 4 ] = { CRect(       0,       0,       352,       240 ), // QUAD

													 CRect(     352,       0,       704,       240 ), // QUAD

													 CRect(       0,     240,       352,       480 ), // QUAD

													 CRect(     352,     240,       704,       480 )  // QUAD
};


CSC2A0Dlg::CSC2A0Dlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSC2A0Dlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSC2A0Dlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32

	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_hVideoDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoDev[ 3 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF;

	m_hVideoSubEncoderDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoSubEncoderDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoSubEncoderDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoSubEncoderDev[ 3 ] = 0xFFFFFFFF;

	m_hAudioDev[ 0 ] = 0xFFFFFFFF;

	m_hAudioDev[ 1 ] = 0xFFFFFFFF;

	m_hAudioDev[ 2 ] = 0xFFFFFFFF;

	m_hAudioDev[ 3 ] = 0xFFFFFFFF;

	m_hVideoDecoderDev[ 0 ] = 0xFFFFFFFF;

	m_hVideoDecoderDev[ 1 ] = 0xFFFFFFFF;

	m_hVideoDecoderDev[ 2 ] = 0xFFFFFFFF;

	m_hVideoDecoderDev[ 3 ] = 0xFFFFFFFF;

	m_hAudioDecoderDev[ 0 ] = 0xFFFFFFFF;

	m_hAudioDecoderDev[ 1 ] = 0xFFFFFFFF;

	m_hAudioDecoderDev[ 2 ] = 0xFFFFFFFF;

	m_hAudioDecoderDev[ 3 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 0 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 1 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 2 ] = 0xFFFFFFFF;

	m_hFileRendererDev[ 3 ] = 0xFFFFFFFF;

	m_nFileRendererRecordState[ 0 ] = 0x00000000;

	m_nFileRendererRecordState[ 1 ] = 0x00000000;

	m_nFileRendererRecordState[ 2 ] = 0x00000000;

	m_nFileRendererRecordState[ 3 ] = 0x00000000;

	m_bFileRendererChangeNotify[ 0 ] = FALSE;

	m_bFileRendererChangeNotify[ 1 ] = FALSE;

	m_bFileRendererChangeNotify[ 2 ] = FALSE;

	m_bFileRendererChangeNotify[ 3 ] = FALSE;

	m_hFileSourceDev[ 0 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 1 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 2 ] = 0xFFFFFFFF;

	m_hFileSourceDev[ 3 ] = 0xFFFFFFFF;

	m_hNetworkRendererDev = 0xFFFFFFFF;

	m_nNetworkRendererStreamingState[ 0 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 1 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 2 ] = 0x00000000;

	m_nNetworkRendererStreamingState[ 3 ] = 0x00000000;
}

void CSC2A0Dlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSC2A0Dlg)
	DDX_Control(pDX, IDC_TAB_DISPLAY, m_tabDisplayExchange);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSC2A0Dlg, CDialog)
	//{{AFX_MSG_MAP(CSC2A0Dlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_DISPLAY, OnSelChangeTabDisplay)
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_WM_ERASEBKGND()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSC2A0Dlg message handlers

BOOL on_process_audio_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_LIVE[ i ]);

	DEVICE_HANDLE    hAudioDev = pMainDialog->m_hAudioDev[ i ];

	DEVICE_HANDLE    hNetworkDev = pMainDialog->m_hNetworkRendererDev;

//	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] >= 0x00000001) ? TRUE : FALSE;

	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000002) ? TRUE : FALSE;

	BOOL             bIsStreaming = (pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000002) ? TRUE : FALSE;

	if( bIsRecord ) {

		EnterCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

		AMESDK_FILE_SET_AUDIO_STREAM_BUFFER( pMainDialog->m_hFileRendererDev[ i ], pBuffer, nBufferLen );

		LeaveCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );
	}
	if( bIsStreaming ) { 
		
		AMESDK_NETWORK_SET_AUDIO_STREAM_BUFFER( hNetworkDev, i, pBuffer, nBufferLen ); // [2009.07.20] [HUENGPEI@YUAN.COM.TW] RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING
	}
	return TRUE;
}

ULONG g_n_video_frame_number[ 4 ] = { 0, 0, 0, 0 };

ULONG g_n_video_main_encoder_frame_number[ 4 ] = { 0, 0, 0, 0 };

ULONG g_n_video_sub_encoder_frame_number[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_start_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_main_encoder_start_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_sub_encoder_start_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_stop_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_main_encoder_stop_sample_time[ 4 ] = { 0, 0, 0, 0 };

double g_d_video_sub_encoder_stop_sample_time[ 4 ] = { 0, 0, 0, 0 };

ULONGLONG g_n_video_main_encoder_stream_size[ 4 ] = { 0, 0, 0, 0 };

ULONGLONG g_n_video_sub_encoder_stream_size[ 4 ] = { 0, 0, 0, 0 };

BOOL g_b_is_start_statistics = FALSE;

BOOL on_process_video_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_LIVE[ i ]);

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000000) ? TRUE : FALSE;

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INTELLIGENT VISION ALGORITHM PRGRAMMING (EXTRA LICENSE)

	if( g_b_is_start_statistics ) {

		if( g_n_video_frame_number[ i ]++ == 0 ) { g_d_video_start_sample_time[ i ] = dSampleTime; }

		g_d_video_stop_sample_time[ i ] = dSampleTime;
	}
	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_video_main_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_H264_MAIN[ i ]);

	DEVICE_HANDLE    hVideoEncoderDev = pMainDialog->m_hVideoMainEncoderDev[ i ];

	DEVICE_HANDLE    hFileDev = pMainDialog->m_hFileRendererDev[ i ];

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000002) ? TRUE : FALSE;

	BOOL             bIsRecord = (pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000002) ? TRUE : FALSE;

	if( bIsKeyFrame ) {

		if( pMainDialog->m_nFileRendererRecordState[ i ] == 0x00000001 ) { // WAITING KEY FRAME

			pMainDialog->m_nFileRendererRecordState[ i ] = 0x00000002; // TO GOTO START STATE

			bIsRecord = TRUE;
		}

		#if ( SC2A0_AUTO_FILE_SEGMENT == 1 )

		SYSTEMTIME system_times; GetLocalTime( &system_times );
	
		if( (pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMinute <  30 && system_times.wMinute >= 30) || // ON TIMEOUT EVENT

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMinute >= 30 && system_times.wMinute <  30) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wHour != system_times.wHour) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wDay != system_times.wDay) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wMonth != system_times.wMonth) ||

			(pMainDialog->m_sFileRendererChangeSystemTime[ i ].wYear != system_times.wYear) ) { 

			CHAR path[ MAX_PATH ];

			pMainDialog->m_oSetupDialog.GetRecordPathParameters( path );

			sprintf( pMainDialog->m_pFileRendererChangeDevName[ i ], "Common Analog File Renderer %sCH%02d\\%04d%02d%02d%02d%02d%02d.AVI", path, i + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			pMainDialog->m_sFileRendererChangeSystemTime[ i ] = system_times;

			pMainDialog->m_bFileRendererChangeNotify[ i ] = TRUE;
		}
		#endif

		if( pMainDialog->m_bFileRendererChangeNotify[ i ] == TRUE ) { // CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]

			ULONG  n_video_color_space_type = 0;

			ULONG  n_video_frame_width = 0;

			ULONG  n_video_frame_height = 0;

			ULONG  n_video_frame_bit_count = 0;

			double f_video_fps = 0.0;

			DWORD  dw_video_custom_flags = 0x00000000;

			ULONG  n_audio_channels = 0;

			ULONG  n_audio_bit_per_sample = 0;

			ULONG  n_audio_samples_per_sec = 0;

			EnterCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

			{	// CLOSE CURRENT RECORD FILE
				//
				if( pMainDialog->m_hFileRendererDev[ i ] != 0xFFFFFFFF ) { 
					
					AMESDK_FILE_GET_VIDEO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], &n_video_color_space_type, &n_video_frame_width, &n_video_frame_height, &n_video_frame_bit_count, &f_video_fps, &dw_video_custom_flags );

					AMESDK_FILE_GET_AUDIO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], &n_audio_channels, &n_audio_bit_per_sample, &n_audio_samples_per_sec );

					AMESDK_DESTROY( pMainDialog->m_hFileRendererDev[ i ] ); 
					
					pMainDialog->m_hFileRendererDev[ i ] = 0xFFFFFFFF;
				}
				// UPDATE CURRENT FILE INFO LIST
				//
				{ ::PostMessage( pMainDialog->m_oSetupDialog.m_oFileManagerWindow.m_hWnd, WM_UPDATE_FILE_INFO_LIST, i, 0 );
				}
				// CREATE NEW RECORD FILE
				//
				{	pMainDialog->m_hFileRendererDev[ i ] = AMESDK_CREATE( pMainDialog->m_pFileRendererChangeDevName[ i ], i /*POOL*/, 3 /*FILE RENDERER*/, NULL, NULL, NULL );

					if( pMainDialog->m_hFileRendererDev[ i ] & 0x80000000 ) {

						pMainDialog->m_hFileRendererDev[ i ] = 0xFFFFFFFF;
					}
					AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], n_video_color_space_type, n_video_frame_width, n_video_frame_height, n_video_frame_bit_count, f_video_fps, dw_video_custom_flags );

					AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( pMainDialog->m_hFileRendererDev[ i ], n_audio_channels, n_audio_bit_per_sample, n_audio_samples_per_sec );

					hFileDev = pMainDialog->m_hFileRendererDev[ i ];
				}
			}

			LeaveCriticalSection( &pMainDialog->m_hFileRendererChangeCriticalSection[ i ] );

			pMainDialog->m_bFileRendererChangeNotify[ i ] = FALSE;
		}
	}
	if( bIsRecord ) {
		
		AMESDK_FILE_SET_VIDEO_STREAM_BUFFER( hFileDev, pBuffer, nBufferLen, bIsKeyFrame );
	}
//	if( bIsRecord && bIsKeyFrame ) {
//
//		AMESDK_FILE_FLUSH( hFileDev ); 
//	}

	if( g_b_is_start_statistics ) {

		if( g_n_video_main_encoder_frame_number[ i ]++ == 0 ) { g_d_video_main_encoder_start_sample_time[ i ] = dSampleTime; }

		g_d_video_main_encoder_stop_sample_time[ i ] = dSampleTime;

		g_n_video_main_encoder_stream_size[ i ] += nBufferLen;
	}
	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_video_sub_encoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_H264_SUB[ i ]);

	DEVICE_HANDLE    hVideoEncoderDev = pMainDialog->m_hVideoSubEncoderDev[ i ];

	DEVICE_HANDLE    hNetworkDev = pMainDialog->m_hNetworkRendererDev;

	BOOL             bIsVisible = (pMainDialog->m_nDisplayModeNumber == 0x00000003) ? TRUE : FALSE;

	BOOL             bIsStreaming = (pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000002) ? TRUE : FALSE;

	if( bIsKeyFrame ) {

		if( pMainDialog->m_nNetworkRendererStreamingState[ i ] == 0x00000001 ) { // WAITING KEY FRAME

			pMainDialog->m_nNetworkRendererStreamingState[ i ] = 0x00000002; // TO GOTO START STATE

			bIsStreaming = TRUE;
		}
	}
	if( bIsStreaming ) { 

		ULONG n_buffer_queue_size = 0;

		ULONG n_frame_queue_size = 0;

		ULONG n_clients = 0;

		AMESDK_NETWORK_GET_VIDEO_STREAM_STATISTICS( hNetworkDev, i, &n_buffer_queue_size, &n_frame_queue_size, &n_clients ); // [2009.07.20] [HUENGPEI@YUAN.COM.TW] RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING

		AMESDK_NETWORK_SET_VIDEO_STREAM_BUFFER( hNetworkDev, i, pBuffer, nBufferLen, bIsKeyFrame ); // [2009.07.20] [HUENGPEI@YUAN.COM.TW] RTP/RTCP/RTSP STREAMMING SERVER PRGRAMMING
	}

	if( g_b_is_start_statistics ) {

		if( g_n_video_sub_encoder_frame_number[ i ]++ == 0 ) { g_d_video_sub_encoder_start_sample_time[ i ] = dSampleTime; }

		g_d_video_sub_encoder_stop_sample_time[ i ] = dSampleTime;

		g_n_video_sub_encoder_stream_size[ i ] += nBufferLen;
	}
	return (bIsVisible) ? TRUE : FALSE; // RETURN FALSE TO REDUCE RENDERER'S CPU COST
}

BOOL on_process_video_decoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_FILE[ i ]);

	DEVICE_HANDLE    hVideoDecoderDev = pMainDialog->m_hVideoDecoderDev[ i ];

	return TRUE;
}

BOOL on_process_audio_decoder_buffer( ULONG nChannelNumber, double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData )
{
	ULONG            i = nChannelNumber - 1;

	CSC2A0Dlg *      pMainDialog = (CSC2A0Dlg *)(pUserData);

	CChannelWindow * pWindow = (CChannelWindow *)(&pMainDialog->m_oChannelWindow_FILE[ i ]);

	DEVICE_HANDLE    hAudioDecoderDev = pMainDialog->m_hAudioDecoderDev[ i ];

	return TRUE;
}

BOOL on_process_video_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_main_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_main_encoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_sub_encoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_sub_encoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_decoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_decoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_decoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_decoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_decoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_decoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_video_decoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_video_decoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_decoder_buffer_CH01( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_decoder_buffer( 0x00000001, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_decoder_buffer_CH02( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_decoder_buffer( 0x00000002, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_decoder_buffer_CH03( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_decoder_buffer( 0x00000003, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

BOOL on_process_audio_decoder_buffer_CH04( double dSampleTime, BYTE * pBuffer, ULONG nBufferLen, BOOL bIsKeyFrame, PVOID pUserData ) { return on_process_audio_decoder_buffer( 0x00000004, dSampleTime, pBuffer, nBufferLen, bIsKeyFrame, pUserData ); }

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSC2A0Dlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSC2A0Dlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CSC2A0Dlg::HwUnInitialize()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] STOP RECORDING & STREAMING
	//
	{	m_bFileRendererChangeNotify[ 0 ] = FALSE;

		m_bFileRendererChangeNotify[ 1 ] = FALSE;
	
		m_bFileRendererChangeNotify[ 2 ] = FALSE;

		m_bFileRendererChangeNotify[ 3 ] = FALSE;
	
		m_nFileRendererRecordState[ 0 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 1 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 2 ] = 0x00000000; // STOP STATE

		m_nFileRendererRecordState[ 3 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 0 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 1 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 2 ] = 0x00000000; // STOP STATE

		m_nNetworkRendererStreamingState[ 3 ] = 0x00000000; // STOP STATE
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	if( m_hVideoDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 0 ] ); m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 1 ] ); m_hVideoDev[ 1 ] = 0xFFFFFFFF; }
		
		if( m_hVideoDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 2 ] ); m_hVideoDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDev[ 3 ] ); m_hVideoDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 0 ] ); m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 1 ] ); m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 2 ] ); m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoMainEncoderDev[ 3 ] ); m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF; }
		
		if( m_hVideoSubEncoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoSubEncoderDev[ 0 ] ); m_hVideoSubEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoSubEncoderDev[ 1 ] ); m_hVideoSubEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoSubEncoderDev[ 2 ] ); m_hVideoSubEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoSubEncoderDev[ 3 ] ); m_hVideoSubEncoderDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 0 ] ); m_hAudioDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 1 ] ); m_hAudioDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 2 ] ); m_hAudioDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDev[ 3 ] ); m_hAudioDev[ 3 ] = 0xFFFFFFFF; }
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE CODEC DECODER RESOURCE
	//
	{	if( m_hVideoDecoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDecoderDev[ 0 ] ); m_hVideoDecoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDecoderDev[ 1 ] ); m_hVideoDecoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDecoderDev[ 2 ] ); m_hVideoDecoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDecoderDev[ 3 ] ); m_hVideoDecoderDev[ 3 ] = 0xFFFFFFFF; }
	}
	{	if( m_hAudioDecoderDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDecoderDev[ 0 ] ); m_hAudioDecoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDecoderDev[ 1 ] ); m_hAudioDecoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDecoderDev[ 2 ] ); m_hAudioDecoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hAudioDecoderDev[ 3 ] ); m_hAudioDecoderDev[ 3 ] = 0xFFFFFFFF; }
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE RENDERER RESOURCE
	//
	{	if( m_hFileRendererDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 0 ] ); m_hFileRendererDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 1 ] ); m_hFileRendererDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 2 ] ); m_hFileRendererDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileRendererDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileRendererDev[ 3 ] ); m_hFileRendererDev[ 3 ] = 0xFFFFFFFF; }

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 0 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 1 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 2 ] );

		DeleteCriticalSection( &m_hFileRendererChangeCriticalSection[ 3 ] );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE SOURCE RESOURCE
	//
	{	if( m_hFileSourceDev[ 0 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 0 ] ); m_hFileSourceDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 1 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 1 ] ); m_hFileSourceDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 2 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 2 ] ); m_hFileSourceDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hFileSourceDev[ 3 ] != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hFileSourceDev[ 3 ] ); m_hFileSourceDev[ 3 ] = 0xFFFFFFFF; }
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE NETWORK RESOURCE
	//
	if( m_hNetworkRendererDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hNetworkRendererDev ); m_hNetworkRendererDev = 0xFFFFFFFF; }

	return TRUE;
}

void CSC2A0Dlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	KillTimer( 0x00000001 );

	KillTimer( 0x00000000 );

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUnInitialize();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindow_LIVE[ 0 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 1 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 2 ].DestroyWindow();

		m_oChannelWindow_LIVE[ 3 ].DestroyWindow();

		m_oChannelWindow_FILE[ 0 ].DestroyWindow();

		m_oChannelWindow_FILE[ 1 ].DestroyWindow();

		m_oChannelWindow_FILE[ 2 ].DestroyWindow();

		m_oChannelWindow_FILE[ 3 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 0 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 1 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 2 ].DestroyWindow();

		m_oChannelWindow_H264_MAIN[ 3 ].DestroyWindow();

		m_oChannelWindow_H264_SUB[ 0 ].DestroyWindow();

		m_oChannelWindow_H264_SUB[ 1 ].DestroyWindow();

		m_oChannelWindow_H264_SUB[ 2 ].DestroyWindow();

		m_oChannelWindow_H264_SUB[ 3 ].DestroyWindow();

		m_oSetupDialog.DestroyWindow();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE AVI RESOURCE
	//
	{	AVIFileExit();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}	
}

BOOL CSC2A0Dlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE AVI RESOURCE
	//
	{	AVIFileInit();
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE USER INTERFACE RESOURCE
	//
	{	CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = 10; // SET CUSTOM BOUNDARY WIDTH OF TAB CONTROL

		ULONG ty = 32; // SET CUSTOM BOUNDARY HEIGHT OF TAB CONTROL

		SetWindowPos( &(CWnd::wndTop), 0, 0, 704 + (cx) + (tx + tx), 480 + (cy) + (ty + tx), SWP_NOMOVE );

		m_tabDisplayExchange.MoveWindow( 0, 0, 704 + (tx + tx), 480 + (ty + tx) );

		m_tabDisplayExchange.InsertItem( 0, "LIVE DISPLAY" );

		m_tabDisplayExchange.InsertItem( 1, "RECORD PLAYBACK" );

		#if ( SC2A0_REALTIME_PLAYBACK_ENABLE == 1 )

		m_tabDisplayExchange.InsertItem( 2, "REALTIME PLAYBACK (MAIN)" );

		m_tabDisplayExchange.InsertItem( 3, "REALTIME PLAYBACK (SUB)" );

		#endif

		m_nDisplayModeNumber = 0x00000000;

		{	g_rect_channel_window_topology_01_704[ 0 ].top += ty; g_rect_channel_window_topology_01_704[ 0 ].bottom += ty; g_rect_channel_window_topology_01_704[ 0 ].left += tx; g_rect_channel_window_topology_01_704[ 0 ].right += tx;

			g_rect_channel_window_topology_04_704[ 0 ].top += ty; g_rect_channel_window_topology_04_704[ 0 ].bottom += ty; g_rect_channel_window_topology_04_704[ 0 ].left += tx; g_rect_channel_window_topology_04_704[ 0 ].right += tx;

			g_rect_channel_window_topology_04_704[ 1 ].top += ty; g_rect_channel_window_topology_04_704[ 1 ].bottom += ty; g_rect_channel_window_topology_04_704[ 1 ].left += tx; g_rect_channel_window_topology_04_704[ 1 ].right += tx;

			g_rect_channel_window_topology_04_704[ 2 ].top += ty; g_rect_channel_window_topology_04_704[ 2 ].bottom += ty; g_rect_channel_window_topology_04_704[ 2 ].left += tx; g_rect_channel_window_topology_04_704[ 2 ].right += tx;

			g_rect_channel_window_topology_04_704[ 3 ].top += ty; g_rect_channel_window_topology_04_704[ 3 ].bottom += ty; g_rect_channel_window_topology_04_704[ 3 ].left += tx; g_rect_channel_window_topology_04_704[ 3 ].right += tx;
		}
		m_oChannelWindow_LIVE[ 0 ].Create( NULL, "MyChannelWindow#LIVE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x00000001, NULL );

		m_oChannelWindow_LIVE[ 1 ].Create( NULL, "MyChannelWindow#LIVE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x00000002, NULL );

		m_oChannelWindow_LIVE[ 2 ].Create( NULL, "MyChannelWindow#LIVE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x00000003, NULL );

		m_oChannelWindow_LIVE[ 3 ].Create( NULL, "MyChannelWindow#LIVE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x00000004, NULL );

		m_oChannelWindow_FILE[ 0 ].Create( NULL, "MyChannelWindow#FILE#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x10000001, NULL );

		m_oChannelWindow_FILE[ 1 ].Create( NULL, "MyChannelWindow#FILE#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x10000002, NULL );

		m_oChannelWindow_FILE[ 2 ].Create( NULL, "MyChannelWindow#FILE#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x10000003, NULL );

		m_oChannelWindow_FILE[ 3 ].Create( NULL, "MyChannelWindow#FILE#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x10000004, NULL );

		m_oChannelWindow_H264_MAIN[ 0 ].Create( NULL, "MyChannelWindow#H264#MAIN#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x20000001, NULL );

		m_oChannelWindow_H264_MAIN[ 1 ].Create( NULL, "MyChannelWindow#H264#MAIN#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x20000002, NULL );

		m_oChannelWindow_H264_MAIN[ 2 ].Create( NULL, "MyChannelWindow#H264#MAIN#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x20000003, NULL );

		m_oChannelWindow_H264_MAIN[ 3 ].Create( NULL, "MyChannelWindow#H264#MAIN#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x20000004, NULL );

		m_oChannelWindow_H264_SUB[ 0 ].Create( NULL, "MyChannelWindow#H264#SUB#01", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 0 ], this, 0x30000001, NULL );

		m_oChannelWindow_H264_SUB[ 1 ].Create( NULL, "MyChannelWindow#H264#SUB#02", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 1 ], this, 0x30000002, NULL );

		m_oChannelWindow_H264_SUB[ 2 ].Create( NULL, "MyChannelWindow#H264#SUB#03", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 2 ], this, 0x30000003, NULL );

		m_oChannelWindow_H264_SUB[ 3 ].Create( NULL, "MyChannelWindow#H264#SUB#04", WS_CHILD | WS_VISIBLE | WS_BORDER, g_rect_channel_window_topology_04_704[ 3 ], this, 0x30000004, NULL );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE );

		SetTimer( 0x00000000, 0, NULL );

		SetTimer( 0x00000001, 1000, NULL );
	}	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

BOOL CSC2A0Dlg::HwInitialize()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GET DEVICE PARAMETERS FROM SETUP DIALOG
	//
	ULONG standard = { 0 };

	ULONG cx[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG cy[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG deinterlace[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	double fps[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG mode[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG bitrate[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG quality[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG gop[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	ULONG bframe[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

	CHAR path[ MAX_PATH ];

	m_oSetupDialog.GetStandardParameters( &standard );

	m_oSetupDialog.GetResolutionParameters( cx, cy );

	m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

	m_oSetupDialog.GetFrameRateParameters( fps );

	m_oSetupDialog.GetRecordModeParameters( mode );

	m_oSetupDialog.GetBitRateParameters( bitrate );

	m_oSetupDialog.GetQualityParameters( quality );

	m_oSetupDialog.GetGOPParameters( gop );

	m_oSetupDialog.GetBFrameParameters( bframe );

	m_oSetupDialog.GetRecordPathParameters( path );

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE NETWORK RESOURCE
	//
	{	m_hNetworkRendererDev = AMESDK_CREATE( "Common Analog Network Renderer streams=4", 0, 5, NULL, NULL, NULL );

		if( m_hNetworkRendererDev & 0x80000000 ) {
			
			m_hNetworkRendererDev = 0xFFFFFFFF;
		}
		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 0, MAKEFOURCC('H', '2', '6', '4'), cx[ 4 ], cy[ 4 ], 24, fps[ 4 ], bitrate[ 4 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 1, MAKEFOURCC('H', '2', '6', '4'), cx[ 5 ], cy[ 5 ], 24, fps[ 5 ], bitrate[ 5 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 2, MAKEFOURCC('H', '2', '6', '4'), cx[ 6 ], cy[ 6 ], 24, fps[ 6 ], bitrate[ 6 ] * 4 );

		AMESDK_NETWORK_SET_VIDEO_STREAM_FORMAT( m_hNetworkRendererDev, 3, MAKEFOURCC('H', '2', '6', '4'), cx[ 7 ], cy[ 7 ], 24, fps[ 7 ], bitrate[ 7 ] * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 0, 1, 16, 16000, 1 * 16 * 16000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 1, 1, 16, 16000, 1 * 16 * 16000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 2, 1, 16, 16000, 1 * 16 * 16000 * 4 );

		AMESDK_NETWORK_SET_AUDIO_STREAM_FORMAT( m_hNetworkRendererDev, 3, 1, 16, 16000, 1 * 16 * 16000 * 4 );

		AMESDK_NETWORK_SET_USER_ACCOUNT( m_hNetworkRendererDev, "root", "root" );

		AMESDK_NETWORK_SET_STREAMING_PORT( m_hNetworkRendererDev, 554 );
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE FILE RESOURCE
	//
	{	SYSTEMTIME system_times; 
	
		CHAR psz[ MAX_PATH ];

		GetLocalTime( &system_times );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			InitializeCriticalSection( &m_hFileRendererChangeCriticalSection[ i ] );

			m_sFileRendererChangeSystemTime[ i ] = system_times;

			sprintf( psz, "Common Analog File Renderer %sCH%02d\\%04d%02d%02d%02d%02d%02d.AVI", path, i + 1, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

			m_hFileRendererDev[ i ] = AMESDK_CREATE( psz, i, 3, NULL, NULL, NULL ); // CH#0X

			if( m_hFileRendererDev[ i ] & 0x80000000 ) {
				
				m_hFileRendererDev[ i ] = 0xFFFFFFFF;
			}
			AMESDK_FILE_SET_VIDEO_STREAM_FORMAT( m_hFileRendererDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cx[ i + 0 ], cy[ i + 0 ], 24, fps[ i + 0 ], (cy[ i + 0 ] > 288) ? AMESDK_FILE_CUSTOMFLAG_ISINTERLEAVED : 0x00000000 ); // RESOLUTION / FRAMERATE

			AMESDK_FILE_SET_AUDIO_STREAM_FORMAT( m_hFileRendererDev[ i ], 1, 16, 16000 ); // MONO / 16BITS / 16000HZ
		}
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE DEVICE RESOURCE
	//
	{	HWND wnd[ 24 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

		PF_BUFFER_CALLBACK bcb[ 24 ] = { NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };
		
		PVOID params[ 24 ] = { this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this, this };

		///////////////////////////////////////////////////////////

		wnd[  0 ] = m_oChannelWindow_LIVE[ 0 ].m_hWnd;

		wnd[  1 ] = m_oChannelWindow_LIVE[ 1 ].m_hWnd;

		wnd[  2 ] = m_oChannelWindow_LIVE[ 2 ].m_hWnd;

		wnd[  3 ] = m_oChannelWindow_LIVE[ 3 ].m_hWnd;

		wnd[  4 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  5 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  6 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  7 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  8 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  9 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 10 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 11 ] = NULL; // DISABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 12 ] = m_oChannelWindow_LIVE[ 0 ].m_hWnd;

		wnd[ 13 ] = m_oChannelWindow_LIVE[ 1 ].m_hWnd;

		wnd[ 14 ] = m_oChannelWindow_LIVE[ 2 ].m_hWnd;

		wnd[ 15 ] = m_oChannelWindow_LIVE[ 3 ].m_hWnd;

		bcb[  0 ] = on_process_video_buffer_CH01;

		bcb[  1 ] = on_process_video_buffer_CH02;

		bcb[  2 ] = on_process_video_buffer_CH03;

		bcb[  3 ] = on_process_video_buffer_CH04;

		bcb[  4 ] = on_process_video_main_encoder_buffer_CH01;

		bcb[  5 ] = on_process_video_main_encoder_buffer_CH02;

		bcb[  6 ] = on_process_video_main_encoder_buffer_CH03;

		bcb[  7 ] = on_process_video_main_encoder_buffer_CH04;

		bcb[  8 ] = on_process_video_sub_encoder_buffer_CH01;

		bcb[  9 ] = on_process_video_sub_encoder_buffer_CH02;

		bcb[ 10 ] = on_process_video_sub_encoder_buffer_CH03;

		bcb[ 11 ] = on_process_video_sub_encoder_buffer_CH04;

		bcb[ 12 ] = on_process_audio_buffer_CH01;

		bcb[ 13 ] = on_process_audio_buffer_CH02;

		bcb[ 14 ] = on_process_audio_buffer_CH03;

		bcb[ 15 ] = on_process_audio_buffer_CH04;

		#if ( SC2A0_REALTIME_PLAYBACK_ENABLE == 1 )	        // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAMS. (RTPB)

		wnd[  4 ] = m_oChannelWindow_H264_MAIN[ 0 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  5 ] = m_oChannelWindow_H264_MAIN[ 1 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  6 ] = m_oChannelWindow_H264_MAIN[ 2 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  7 ] = m_oChannelWindow_H264_MAIN[ 3 ].m_hWnd; // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  8 ] = m_oChannelWindow_H264_SUB[ 0 ].m_hWnd;  // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[  9 ] = m_oChannelWindow_H264_SUB[ 1 ].m_hWnd;  // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 10 ] = m_oChannelWindow_H264_SUB[ 2 ].m_hWnd;  // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.

		wnd[ 11 ] = m_oChannelWindow_H264_SUB[ 3 ].m_hWnd;  // ENABLE REALTIME PLAYBACK OF H.264 BITSTREAM.
		
		#endif

		#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )	   // ENABLE RECORD PLAYBACK OF H.264 BITSTREAMS. (RCPB)

		wnd[ 16 ] = m_oChannelWindow_FILE[ 0 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 17 ] = m_oChannelWindow_FILE[ 1 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 18 ] = m_oChannelWindow_FILE[ 2 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 19 ] = m_oChannelWindow_FILE[ 3 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		bcb[ 16 ] = on_process_video_decoder_buffer_CH01;

		bcb[ 17 ] = on_process_video_decoder_buffer_CH02;

		bcb[ 18 ] = on_process_video_decoder_buffer_CH03;

		bcb[ 19 ] = on_process_video_decoder_buffer_CH04;

		wnd[ 20 ] = m_oChannelWindow_FILE[ 0 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 21 ] = m_oChannelWindow_FILE[ 1 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 22 ] = m_oChannelWindow_FILE[ 2 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		wnd[ 23 ] = m_oChannelWindow_FILE[ 3 ].m_hWnd; // ENABLE RECORD PLAYBACK OF H.264 BITSTREAM.

		bcb[ 20 ] = on_process_audio_decoder_buffer_CH01;

		bcb[ 21 ] = on_process_audio_decoder_buffer_CH02;

		bcb[ 22 ] = on_process_audio_decoder_buffer_CH03;

		bcb[ 23 ] = on_process_audio_decoder_buffer_CH04;

		#endif

		/////////////////////////////////////////////////////////////////////////////////////////////////

		m_hVideoDev[ 0 ] = AMESDK_CREATE( "FH8735 PCI", 0, 0, wnd[ 0 ], bcb[ 0 ], params[ 0 ] ); // CH#01

		m_hVideoDev[ 1 ] = AMESDK_CREATE( "FH8735 PCI", 1, 0, wnd[ 1 ], bcb[ 1 ], params[ 1 ] ); // CH#02

		m_hVideoDev[ 2 ] = AMESDK_CREATE( "FH8735 PCI", 2, 0, wnd[ 2 ], bcb[ 2 ], params[ 2 ] ); // CH#03

		m_hVideoDev[ 3 ] = AMESDK_CREATE( "FH8735 PCI", 3, 0, wnd[ 3 ], bcb[ 3 ], params[ 3 ] ); // CH#04

		m_hVideoMainEncoderDev[ 0 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 0, 0, wnd[ 4 ], bcb[ 4 ], params[ 4 ] ); // CH#01

		m_hVideoMainEncoderDev[ 1 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 1, 0, wnd[ 5 ], bcb[ 5 ], params[ 5 ] ); // CH#02

		m_hVideoMainEncoderDev[ 2 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 2, 0, wnd[ 6 ], bcb[ 6 ], params[ 6 ] ); // CH#03

		m_hVideoMainEncoderDev[ 3 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 3, 0, wnd[ 7 ], bcb[ 7 ], params[ 7 ] ); // CH#04

		m_hVideoSubEncoderDev[ 0 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 0, 0, wnd[  8 ], bcb[  8 ], params[  8 ] ); // CH#01

		m_hVideoSubEncoderDev[ 1 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 1, 0, wnd[  9 ], bcb[  9 ], params[  9 ] ); // CH#02

		m_hVideoSubEncoderDev[ 2 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 2, 0, wnd[ 10 ], bcb[ 10 ], params[ 10 ] ); // CH#03

		m_hVideoSubEncoderDev[ 3 ] = AMESDK_CREATE( "FH8735 PCI, Analog Encoder", 3, 0, wnd[ 11 ], bcb[ 11 ], params[ 11 ] ); // CH#04

		m_hAudioDev[ 0 ] = AMESDK_CREATE( "FH8735 PCI, Analog WaveIn", 0, 0, wnd[ 12 ], bcb[ 12 ], params[ 12 ] ); // CH#01

		m_hAudioDev[ 1 ] = AMESDK_CREATE( "FH8735 PCI, Analog WaveIn", 1, 0, wnd[ 13 ], bcb[ 13 ], params[ 13 ] ); // CH#02

		m_hAudioDev[ 2 ] = AMESDK_CREATE( "FH8735 PCI, Analog WaveIn", 2, 0, wnd[ 14 ], bcb[ 14 ], params[ 14 ] ); // CH#03

		m_hAudioDev[ 3 ] = AMESDK_CREATE( "FH8735 PCI, Analog WaveIn", 3, 0, wnd[ 15 ], bcb[ 15 ], params[ 15 ] ); // CH#04

		#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )

		m_hVideoDecoderDev[ 0 ] = AMESDK_CREATE( "Common Analog Decoder (H.264)", 0, 6, wnd[ 16 ], bcb[ 16 ], params[ 16 ] ); // CH#01

		m_hVideoDecoderDev[ 1 ] = AMESDK_CREATE( "Common Analog Decoder (H.264)", 1, 6, wnd[ 17 ], bcb[ 17 ], params[ 17 ] ); // CH#02

		m_hVideoDecoderDev[ 2 ] = AMESDK_CREATE( "Common Analog Decoder (H.264)", 2, 6, wnd[ 18 ], bcb[ 18 ], params[ 18 ] ); // CH#03

		m_hVideoDecoderDev[ 3 ] = AMESDK_CREATE( "Common Analog Decoder (H.264)", 3, 6, wnd[ 19 ], bcb[ 19 ], params[ 19 ] ); // CH#04

		m_hAudioDecoderDev[ 0 ] = AMESDK_CREATE( "Common Analog Decoder (PCM)", 0, 6, wnd[ 20 ], bcb[ 20 ], params[ 20 ] ); // CH#01

		m_hAudioDecoderDev[ 1 ] = AMESDK_CREATE( "Common Analog Decoder (PCM)", 1, 6, wnd[ 21 ], bcb[ 21 ], params[ 21 ] ); // CH#02

		m_hAudioDecoderDev[ 2 ] = AMESDK_CREATE( "Common Analog Decoder (PCM)", 2, 6, wnd[ 22 ], bcb[ 22 ], params[ 22 ] ); // CH#03

		m_hAudioDecoderDev[ 3 ] = AMESDK_CREATE( "Common Analog Decoder (PCM)", 3, 6, wnd[ 23 ], bcb[ 23 ], params[ 23 ] ); // CH#04

		#endif

		if( m_hVideoDev[ 0 ] & 0x80000000 ) { m_hVideoDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 1 ] & 0x80000000 ) { m_hVideoDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 2 ] & 0x80000000 ) { m_hVideoDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDev[ 3 ] & 0x80000000 ) { m_hVideoDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 0 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 1 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 2 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoMainEncoderDev[ 3 ] & 0x80000000 ) { m_hVideoMainEncoderDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 0 ] & 0x80000000 ) { m_hVideoSubEncoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 1 ] & 0x80000000 ) { m_hVideoSubEncoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 2 ] & 0x80000000 ) { m_hVideoSubEncoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoSubEncoderDev[ 3 ] & 0x80000000 ) { m_hVideoSubEncoderDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 0 ] & 0x80000000 ) { m_hAudioDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 1 ] & 0x80000000 ) { m_hAudioDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 2 ] & 0x80000000 ) { m_hAudioDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDev[ 3 ] & 0x80000000 ) { m_hAudioDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 0 ] & 0x80000000 ) { m_hVideoDecoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 1 ] & 0x80000000 ) { m_hVideoDecoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 2 ] & 0x80000000 ) { m_hVideoDecoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hVideoDecoderDev[ 3 ] & 0x80000000 ) { m_hVideoDecoderDev[ 3 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 0 ] & 0x80000000 ) { m_hAudioDecoderDev[ 0 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 1 ] & 0x80000000 ) { m_hAudioDecoderDev[ 1 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 2 ] & 0x80000000 ) { m_hAudioDecoderDev[ 2 ] = 0xFFFFFFFF; }

		if( m_hAudioDecoderDev[ 3 ] & 0x80000000 ) { m_hAudioDecoderDev[ 3 ] = 0xFFFFFFFF; }

		// SETUP LIVE PATH (UYVY) PROPERTIES
		// 
		for( ULONG i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_STANDARD( m_hVideoDev[ i ], standard ); // STANDARD

			if( standard & 0x00000001 ) { AMESDK_SET_FORMAT( m_hVideoDev[ i ], MAKEFOURCC('Y', 'V', '1', '2'), 704, 480, 12, 29.97 ); } // RESOLUTION = 704  480  29.97 / NTSC

			if( standard & 0x00000010 ) { AMESDK_SET_FORMAT( m_hVideoDev[ i ], MAKEFOURCC('Y', 'V', '1', '2'), 704, 576, 12, 25.00 ); } // RESOLUTION = 704  576  25.00 / PALB

		//	AMESDK_SET_DEINTERLACE( m_hVideoDev[ i ], 0x00000007 ); // SOFTWARE-BASED DEINTERLACE

			if( deinterlace[ i ] == 0 ) { AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDev[ i ], 200, 0 ); } // HARDWARE-BASED DEINTERLACE

			if( deinterlace[ i ] == 1 ) { AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDev[ i ], 200, 2 ); } // HARDWARE-BASED DEINTERLACE

			if( deinterlace[ i ] >= 7 ) { AMESDK_SET_CUSTOM_PROPERTY( m_hVideoDev[ i ], 200, 4 ); } // HARDWARE-BASED DEINTERLACE

			{	CHAR psz[ MAX_PATH ];
				
				GetModuleFileName( NULL, psz, MAX_PATH );

				psz[ strlen( psz ) - 10 ] = 0x00;

			//	sprintf( psz, "%s\\NONE.OSD.TXT", psz );

				sprintf( psz, "%s\\OSD.TXT", psz );

				AMESDK_SET_CUSTOM_PROPERTY_EX( m_hVideoDev[ i ], 921, (BYTE *)(psz), sizeof(psz) );
			}
		}
		// SETUP RECORDING PATH (H.264) PROPERTIES
		// 
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_STANDARD( m_hVideoMainEncoderDev[ i ], standard ); // STANDARD

			AMESDK_SET_FORMAT( m_hVideoMainEncoderDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cx[ i ], cy[ i ], 24, fps[ i ] ); // RESOLUTION / FRAMERATE

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000003, mode[ i ] ); // RECORD MODE

			if( mode[ i ] == 0 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000001, quality[ i ] ); } // QUALITY (VBR)

			if( mode[ i ] == 1 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000004, bitrate[ i ] ); } // BITRATE (CBR)
		
			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x00000000, gop[ i ] ); // GOP

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoMainEncoderDev[ i ], 0x0000000A, bframe[ i ] ); // BFRAME

		//	AMESDK_SET_DEINTERLACE( m_hVideoMainEncoderDev[ i ], (cy[ i ] > 288) ? (deinterlace[ i ]) : (0x00000000) ); // SOFTWARE-BASED DEINTERLACE
		}
		// SETUP STREAMING PATH (H.264) PROPERTIES
		// 
		for( i = 4 ; i < 8 ; i++ ) {

			AMESDK_SET_STANDARD( m_hVideoSubEncoderDev[ i - 4 ], standard ); // STANDARD

			AMESDK_SET_FORMAT( m_hVideoSubEncoderDev[ i - 4 ], MAKEFOURCC('X', '2', '6', '4'), cx[ i ], cy[ i ], 24, fps[ i ] ); // RESOLUTION / FRAMERATE

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev[ i - 4 ], 0x00000003, mode[ i ] ); // RECORD MODE

			if( mode[ i ] == 0 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev[ i - 4 ], 0x00000001, quality[ i ] ); } // QUALITY (VBR)

			if( mode[ i ] == 1 ) { AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev[ i - 4 ], 0x00000004, bitrate[ i ] ); } // BITRATE (CBR)
		
			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev[ i - 4 ], 0x00000000, gop[ i ] ); // GOP

			AMESDK_SET_VIDEOCOMPRESSION_PROPERTY( m_hVideoSubEncoderDev[ i - 4 ], 0x0000000A, bframe[ i ] ); // BFRAME

		//	AMESDK_SET_DEINTERLACE( m_hVideoSubEncoderDev[ i - 4 ], 0x00000000 ); // SOFTWARE-BASED DEINTERLACE
		}
		// SETUP AUDIO PATH (PCM) PROPERTIES
		//
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_FORMAT( m_hAudioDev[ i ], 1, 16, 16000 ); // MONO / 16BITS / 16000HZ
		}
		// SETUP DECODE PATH (H.264) PROPERTIES
		//
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_FORMAT( m_hVideoDecoderDev[ i ], MAKEFOURCC('H', '2', '6', '4'), cx[ i + 0 ], cy[ i + 0 ], 24, fps[ i + 0 ] ); // RESOLUTION / FRAMERATE

		//	AMESDK_SET_DEINTERLACE( m_hVideoDecoderDev[ i ], (cy[ i ] > 288) ? (deinterlace[ i ]) : (0x00000000) ); // SOFTWARE-BASED DEINTERLACE	
		}
		// SETUP DECODE PATH (PCM) PROPERTIES
		//
		for( i = 0 ; i < 4 ; i++ ) {

			AMESDK_SET_FORMAT( m_hAudioDecoderDev[ i ], 1, 16, 16000 ); // MONO / 16BITS / 16000HZ
		}
		// START
		//
		for( i = 0 ; i < 4 ; i++ ) {

			g_n_video_frame_number[ i ] = 0;

			g_n_video_main_encoder_frame_number[ i ] = 0;

			g_n_video_sub_encoder_frame_number[ i ] = 0;

			g_d_video_start_sample_time[ i ] = 0;

			g_d_video_main_encoder_start_sample_time[ i ] = 0;

			g_d_video_sub_encoder_start_sample_time[ i ] = 0;

			g_d_video_stop_sample_time[ i ] = 0;

			g_d_video_main_encoder_stop_sample_time[ i ] = 0;

			g_d_video_sub_encoder_stop_sample_time[ i ] = 0;

			g_n_video_main_encoder_stream_size[ i ] = 0;

			g_n_video_sub_encoder_stream_size[ i ] = 0;

			g_b_is_start_statistics = FALSE;
		}
		AMESDK_RUN( m_hVideoDecoderDev[ 0 ] );

		AMESDK_RUN( m_hVideoDecoderDev[ 1 ] );

		AMESDK_RUN( m_hVideoDecoderDev[ 2 ] );

		AMESDK_RUN( m_hVideoDecoderDev[ 3 ] );

		AMESDK_RUN( m_hAudioDecoderDev[ 0 ] );

		AMESDK_RUN( m_hAudioDecoderDev[ 1 ] );

		AMESDK_RUN( m_hAudioDecoderDev[ 2 ] );

		AMESDK_RUN( m_hAudioDecoderDev[ 3 ] );

		AMESDK_RUN( m_hVideoDev[ 0 ] );
		
		AMESDK_RUN( m_hVideoDev[ 1 ] );

		AMESDK_RUN( m_hVideoDev[ 2 ] );
		
		AMESDK_RUN( m_hVideoDev[ 3 ] );

		AMESDK_RUN( m_hVideoMainEncoderDev[ 0 ] );

		AMESDK_RUN( m_hVideoMainEncoderDev[ 1 ] );

		AMESDK_RUN( m_hVideoMainEncoderDev[ 2 ] );

		AMESDK_RUN( m_hVideoMainEncoderDev[ 3 ] );

		AMESDK_RUN( m_hVideoSubEncoderDev[ 0 ] );

		AMESDK_RUN( m_hVideoSubEncoderDev[ 1 ] );

		AMESDK_RUN( m_hVideoSubEncoderDev[ 2 ] );

		AMESDK_RUN( m_hVideoSubEncoderDev[ 3 ] );

		AMESDK_RUN( m_hAudioDev[ 0 ] );
		
		AMESDK_RUN( m_hAudioDev[ 1 ] );

		AMESDK_RUN( m_hAudioDev[ 2 ] );
		
		AMESDK_RUN( m_hAudioDev[ 3 ] );

		Sleep( 512 );

		g_b_is_start_statistics = TRUE;

		// HERE, EVERY CHANNEL SHOULD OUTPUT 3 BITSTREAMS: LIVE + H.264 + AUDIO
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] START RECORDING
	//
	{	m_bFileRendererChangeNotify[ 0 ] = FALSE;

		m_bFileRendererChangeNotify[ 1 ] = FALSE;
	
		m_bFileRendererChangeNotify[ 2 ] = FALSE;

		m_bFileRendererChangeNotify[ 3 ] = FALSE;
	
		m_nFileRendererRecordState[ 0 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 1 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 2 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		m_nFileRendererRecordState[ 3 ] = 0x00000001; // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
	}
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] START STREAMING
	//
	{	if( m_hNetworkRendererDev      != 0xFFFFFFFF ) { AMESDK_RUN( m_hNetworkRendererDev ); }

		if( m_hVideoSubEncoderDev[ 0 ] != 0xFFFFFFFF ) { m_nNetworkRendererStreamingState[ 0 ] = 0x00000001; } // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		if( m_hVideoSubEncoderDev[ 1 ] != 0xFFFFFFFF ) { m_nNetworkRendererStreamingState[ 1 ] = 0x00000001; } // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		if( m_hVideoSubEncoderDev[ 2 ] != 0xFFFFFFFF ) { m_nNetworkRendererStreamingState[ 2 ] = 0x00000001; } // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME

		if( m_hVideoSubEncoderDev[ 3 ] != 0xFFFFFFFF ) { m_nNetworkRendererStreamingState[ 3 ] = 0x00000001; } // ACQUIRE STATE: TO GOTO START STATE AFTER WAITING ONE KEY FRAME
	}
	return TRUE;
}

void CSC2A0Dlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	//
	if( nIDEvent == 0x00000000 ) {

		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width(); // GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height(); // GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		ULONG tx = (1056 - 704 - 20) >> 1;

		m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

		m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), oWindowRect.left - tx, oWindowRect.bottom - 100 + 5, cx + 1056, cy + 230, NULL );

		m_oSetupDialog.ShowWindow( TRUE );

		SetWindowPos( NULL, oWindowRect.left, 5, 0, 0, SWP_NOSIZE | SWP_NOZORDER );

		SetFocus();

		m_oSetupDialog.UpdateWindow();

		KillTimer( 0x00000000 );

		// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE DEVICE RESOURCE
		//
		HwInitialize();
	}
	if( nIDEvent == 0x00000001 ) {

		double fps[ 12 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

		double bps[ 12 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };

		if( g_n_video_frame_number[ 0 ]              > 0 ) { fps[  0 ] = (g_d_video_stop_sample_time[ 0 ]              - g_d_video_start_sample_time[ 0 ]             ) / (g_n_video_frame_number[ 0 ]); }

		if( g_n_video_frame_number[ 1 ]              > 0 ) { fps[  1 ] = (g_d_video_stop_sample_time[ 1 ]              - g_d_video_start_sample_time[ 1 ]             ) / (g_n_video_frame_number[ 1 ]); }

		if( g_n_video_frame_number[ 2 ]              > 0 ) { fps[  2 ] = (g_d_video_stop_sample_time[ 2 ]              - g_d_video_start_sample_time[ 2 ]             ) / (g_n_video_frame_number[ 2 ]); }

		if( g_n_video_frame_number[ 3 ]              > 0 ) { fps[  3 ] = (g_d_video_stop_sample_time[ 3 ]              - g_d_video_start_sample_time[ 3 ]             ) / (g_n_video_frame_number[ 3 ]); }

		if( g_n_video_main_encoder_frame_number[ 0 ] > 0 ) { fps[  4 ] = (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) / (g_n_video_main_encoder_frame_number[ 0 ]); }

		if( g_n_video_main_encoder_frame_number[ 1 ] > 0 ) { fps[  5 ] = (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) / (g_n_video_main_encoder_frame_number[ 1 ]); }

		if( g_n_video_main_encoder_frame_number[ 2 ] > 0 ) { fps[  6 ] = (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) / (g_n_video_main_encoder_frame_number[ 2 ]); }

		if( g_n_video_main_encoder_frame_number[ 3 ] > 0 ) { fps[  7 ] = (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) / (g_n_video_main_encoder_frame_number[ 3 ]); }

		if( g_n_video_sub_encoder_frame_number[ 0 ]  > 0 ) { fps[  8 ] = (g_d_video_sub_encoder_stop_sample_time[ 0 ]  - g_d_video_sub_encoder_start_sample_time[ 0 ] ) / (g_n_video_sub_encoder_frame_number[ 0 ]); }

		if( g_n_video_sub_encoder_frame_number[ 1 ]  > 0 ) { fps[  9 ] = (g_d_video_sub_encoder_stop_sample_time[ 1 ]  - g_d_video_sub_encoder_start_sample_time[ 1 ] ) / (g_n_video_sub_encoder_frame_number[ 1 ]); }

		if( g_n_video_sub_encoder_frame_number[ 2 ]  > 0 ) { fps[ 10 ] = (g_d_video_sub_encoder_stop_sample_time[ 2 ]  - g_d_video_sub_encoder_start_sample_time[ 2 ] ) / (g_n_video_sub_encoder_frame_number[ 2 ]); }

		if( g_n_video_sub_encoder_frame_number[ 3 ]  > 0 ) { fps[ 11 ] = (g_d_video_sub_encoder_stop_sample_time[ 3 ]  - g_d_video_sub_encoder_start_sample_time[ 3 ] ) / (g_n_video_sub_encoder_frame_number[ 3 ]); }

		if( (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) > 0 ) { bps[  4 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 0 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 0 ] - g_d_video_main_encoder_start_sample_time[ 0 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) > 0 ) { bps[  5 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 1 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 1 ] - g_d_video_main_encoder_start_sample_time[ 1 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) > 0 ) { bps[  6 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 2 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 2 ] - g_d_video_main_encoder_start_sample_time[ 2 ]) / 100.0; }

		if( (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) > 0 ) { bps[  7 ] = (ULONG)(g_n_video_main_encoder_stream_size[ 3 ] * 8 / 1024 / 1024) / (g_d_video_main_encoder_stop_sample_time[ 3 ] - g_d_video_main_encoder_start_sample_time[ 3 ]) / 100.0; }

		if( (g_d_video_sub_encoder_stop_sample_time[ 0 ]  - g_d_video_sub_encoder_start_sample_time[ 0 ] ) > 0 ) { bps[  8 ] = (ULONG)(g_n_video_sub_encoder_stream_size[ 0 ]  * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[ 0 ]  - g_d_video_sub_encoder_start_sample_time[ 0 ] ) / 100.0; }

		if( (g_d_video_sub_encoder_stop_sample_time[ 1 ]  - g_d_video_sub_encoder_start_sample_time[ 1 ] ) > 0 ) { bps[  9 ] = (ULONG)(g_n_video_sub_encoder_stream_size[ 1 ]  * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[ 1 ]  - g_d_video_sub_encoder_start_sample_time[ 1 ] ) / 100.0; }

		if( (g_d_video_sub_encoder_stop_sample_time[ 2 ]  - g_d_video_sub_encoder_start_sample_time[ 2 ] ) > 0 ) { bps[ 10 ] = (ULONG)(g_n_video_sub_encoder_stream_size[ 2 ]  * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[ 2 ]  - g_d_video_sub_encoder_start_sample_time[ 2 ] ) / 100.0; }

		if( (g_d_video_sub_encoder_stop_sample_time[ 3 ]  - g_d_video_sub_encoder_start_sample_time[ 3 ] ) > 0 ) { bps[ 11 ] = (ULONG)(g_n_video_sub_encoder_stream_size[ 3 ]  * 8 / 1024 / 1024) / (g_d_video_sub_encoder_stop_sample_time[ 3 ]  - g_d_video_sub_encoder_start_sample_time[ 3 ] ) / 100.0; }

		SC2A0_DEBUG( "FPS = |%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|", fps[ 0 ], fps[ 1 ], fps[ 2 ], fps[ 3 ], fps[ 4 ], fps[ 5 ], fps[ 6 ], fps[ 7 ], fps[ 8 ], fps[ 9 ], fps[ 10 ], fps[ 11 ] );

		SC2A0_DEBUG( "BPS = |%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|%.6f|", bps[ 0 ], bps[ 1 ], bps[ 2 ], bps[ 3 ], bps[ 4 ], bps[ 5 ], bps[ 6 ], bps[ 7 ], bps[ 8 ], bps[ 9 ], bps[ 10 ], bps[ 11 ] );

		SC2A0_DEBUG( "NUM = |%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|%08d|", g_n_video_frame_number[ 0 ], g_n_video_frame_number[ 2 ], g_n_video_frame_number[ 2 ], g_n_video_frame_number[ 3 ], g_n_video_main_encoder_frame_number[ 0 ], g_n_video_main_encoder_frame_number[ 2 ], g_n_video_main_encoder_frame_number[ 2 ], g_n_video_main_encoder_frame_number[ 3 ], g_n_video_sub_encoder_frame_number[ 0 ], g_n_video_sub_encoder_frame_number[ 2 ], g_n_video_sub_encoder_frame_number[ 2 ], g_n_video_sub_encoder_frame_number[ 3 ] );
	}
	CDialog::OnTimer(nIDEvent);
}

void CSC2A0Dlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

extern volatile HANDLE  g_h_export_file_to_disk_thread;

void CSC2A0Dlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	if( g_h_export_file_to_disk_thread != NULL ) {

		AfxMessageBox( "FILE EXPROTING ...\n\nDON'T CLOSE SOFTWARE !!!" );

		return ;
	}
	CDialog::OnCancel();
}

BOOL CSC2A0Dlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING
	// 
	{	CBrush brush( RGB( 236, 233, 216 ) );

		CRect rect_client; 

		CRgn rgn_client;

		CRgn rgn_children;

		GetClientRect( &rect_client );

		rgn_client.CreateRectRgn( rect_client.left, rect_client.top, rect_client.right, rect_client.bottom );

		rgn_children.CreateRectRgn( 0, 0, 0, 0 );

		for( ULONG i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_LIVE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_LIVE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_FILE[ i ].IsWindowVisible() ) {

				m_oChannelWindow_FILE[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_H264_MAIN[ i ].IsWindowVisible() ) {

				m_oChannelWindow_H264_MAIN[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		for( i = 0 ; i < 4 ; i++ ) {

			CRect rect_child; 

			CRgn rgn_child;

			if( m_oChannelWindow_H264_SUB[ i ].IsWindowVisible() ) {

				m_oChannelWindow_H264_SUB[ i ].GetWindowRect( &rect_child );

				ScreenToClient( &rect_child );

				rgn_child.CreateRectRgn( rect_child.left, rect_child.top, rect_child.right, rect_child.bottom );

				rgn_children.CombineRgn( &rgn_children, &rgn_child, RGN_OR );
			}
		}
		rgn_client.CombineRgn( &rgn_client, &rgn_children, RGN_XOR );

		pDC->FillRgn( &rgn_client, &brush );
	}
	return TRUE;
	
	return CDialog::OnEraseBkgnd(pDC);
}

void CSC2A0Dlg::OnSelChangeTabDisplay(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (LIVE/RCPB/RTPB)
	//
	m_nDisplayModeNumber = m_tabDisplayExchange.GetCurSel();

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE

		m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000001 ) { // RCPB

		m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		#if ( SC2A0_RECORD_PLAYBACK_METHOD == 0 )

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] );

		#endif

		#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 3 ] );

		#endif

		m_oChannelWindow_FILE[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000002 ) { // RTPB

		m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE );
	}
	if( m_nDisplayModeNumber == 0x00000003 ) { // RTPB

		m_oChannelWindow_H264_SUB[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ], FALSE ); // QUAD

		m_oChannelWindow_H264_SUB[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ], FALSE ); // QUAD

		m_oChannelWindow_H264_SUB[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ], FALSE ); // QUAD

		m_oChannelWindow_H264_SUB[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ], FALSE ); // QUAD

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 0 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 1 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 2 ] );

		AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 3 ] );

		m_oChannelWindow_H264_SUB[ 0 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_SUB[ 1 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_SUB[ 2 ].ShowWindow(  TRUE );

		m_oChannelWindow_H264_SUB[ 3 ].ShowWindow(  TRUE );

		m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE );

		m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE );
	}

	m_oSetupDialog.OnSelChangeTabDisplay_SC2A0Dlg( m_nDisplayModeNumber );

   *pResult = 0;
}

BOOL CSC2A0Dlg::OnLButtonDown_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (LIVE MODE)
	//
	if( nChannelNumber == 0x00000001 ||

		nChannelNumber == 0x00000002 ||

		nChannelNumber == 0x00000003 ||

		nChannelNumber == 0x00000004 ) {

		nChannelNumber -= 0x00000001;

		CRect rect;
	
		m_oChannelWindow_LIVE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }

		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_LIVE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_LIVE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDev[ 3 ] ); }
		}
	}

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (RCPB MODE)
	//
	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 0 )	

	if( nChannelNumber == 0x10000001 ||

		nChannelNumber == 0x10000002 ||

		nChannelNumber == 0x10000003 ||

		nChannelNumber == 0x10000004 ) {

		nChannelNumber -= 0x10000001;

		CRect rect;
	
		m_oChannelWindow_FILE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hFileSourceDev[ 3 ] ); }
		}
	}

	#endif

	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )	

	if( nChannelNumber == 0x10000001 ||

		nChannelNumber == 0x10000002 ||

		nChannelNumber == 0x10000003 ||

		nChannelNumber == 0x10000004 ) {

		nChannelNumber -= 0x10000001;

		CRect rect;
	
		m_oChannelWindow_FILE[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 3 ] ); }
		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_FILE[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_FILE[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoDecoderDev[ 3 ] ); }
		}
	}

	#endif

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (RTPB MODE)
	//
	#if ( SC2A0_REALTIME_PLAYBACK_ENABLE == 1 )	

	if( nChannelNumber == 0x20000001 ||

		nChannelNumber == 0x20000002 ||

		nChannelNumber == 0x20000003 ||

		nChannelNumber == 0x20000004 ) {

		nChannelNumber -= 0x20000001;

		CRect rect;
	
		m_oChannelWindow_H264_MAIN[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] ); }

		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_MAIN[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_MAIN[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoMainEncoderDev[ 3 ] ); }
		}
	}

	#endif

	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] USER INTERFACE RELATED PROGRAMMING (RTPB MODE)
	//
	#if ( SC2A0_REALTIME_PLAYBACK_ENABLE == 1 )	

	if( nChannelNumber == 0x30000001 ||

		nChannelNumber == 0x30000002 ||

		nChannelNumber == 0x30000003 ||

		nChannelNumber == 0x30000004 ) {

		nChannelNumber -= 0x30000001;

		CRect rect;
	
		m_oChannelWindow_H264_SUB[ nChannelNumber ].GetWindowRect( &rect );

		if( rect.Width() > 360 ) { // FULLSCREEN -> QUAD

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 0 ].MoveWindow( g_rect_channel_window_topology_04_704[ 0 ] ); } // QUAD

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 1 ].MoveWindow( g_rect_channel_window_topology_04_704[ 1 ] ); } // QUAD

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 2 ].MoveWindow( g_rect_channel_window_topology_04_704[ 2 ] ); } // QUAD

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( TRUE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 3 ].MoveWindow( g_rect_channel_window_topology_04_704[ 3 ] ); } // QUAD

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 3 ] ); }

		}
		else { // QUAD -> FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 0 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 0 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 0 ] ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 1 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 1 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 1 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 1 ] ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 2 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 2 ) { m_oChannelWindow_H264_SUB[ 3 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 2 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 2 ] ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 3 ].MoveWindow( g_rect_channel_window_topology_01_704[ 0 ] ); } // FULLSCREEN

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 0 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 1 ].ShowWindow( FALSE ); }
			
			if( nChannelNumber == 3 ) { m_oChannelWindow_H264_SUB[ 2 ].ShowWindow( FALSE ); }

			if( nChannelNumber == 3 ) { AMESDK_OTHER_REFRESH_DISPLAY_WINDOW( m_hVideoSubEncoderDev[ 3 ] ); }
		}
	}

	#endif

	return TRUE;
}

BOOL CSC2A0Dlg::OnLButtonUp_ChannelWindow( ULONG nChannelNumber, UINT nFlags, CPoint Point )
{
	return TRUE;
}

BOOL CSC2A0Dlg::OnSync_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] CHANGE CURRENT RECORD FILE [FILE.CHANGING.EVENT]
	//
	SYSTEMTIME system_times; 
	
	GetLocalTime( &system_times );

	CHAR path[ MAX_PATH ];

	m_oSetupDialog.GetRecordPathParameters( path );

	sprintf( m_pFileRendererChangeDevName[ 0 ], "Common Analog File Renderer %sCH01\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 1 ], "Common Analog File Renderer %sCH02\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 2 ], "Common Analog File Renderer %sCH03\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	sprintf( m_pFileRendererChangeDevName[ 3 ], "Common Analog File Renderer %sCH04\\%04d%02d%02d%02d%02d%02d.AVI", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond );

	m_sFileRendererChangeSystemTime[ 0 ] = system_times;

	m_sFileRendererChangeSystemTime[ 1 ] = system_times;

	m_sFileRendererChangeSystemTime[ 2 ] = system_times;

	m_sFileRendererChangeSystemTime[ 3 ] = system_times;

	m_bFileRendererChangeNotify[ 0 ] = TRUE;

	m_bFileRendererChangeNotify[ 1 ] = TRUE;

	m_bFileRendererChangeNotify[ 2 ] = TRUE;

	m_bFileRendererChangeNotify[ 3 ] = TRUE;

	// WAITING FILE.CHANGE.EVENT COMPLETE ...
	//
	if( m_hVideoMainEncoderDev[ 0 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 0 ] == TRUE ) { ; } }

	if( m_hVideoMainEncoderDev[ 1 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 1 ] == TRUE ) { ; } }

	if( m_hVideoMainEncoderDev[ 2 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 2 ] == TRUE ) { ; } }

	if( m_hVideoMainEncoderDev[ 3 ] != 0xFFFFFFFF ) { while( m_bFileRendererChangeNotify[ 3 ] == TRUE ) { ; } }

	return TRUE;
}

BOOL CSC2A0Dlg::OnSnapshot_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] SNAPSHOT FUNCTION PROGRAMMING
	//
	CHAR path[ MAX_PATH ];

	CHAR psz[ MAX_PATH ];

	SYSTEMTIME system_times; 
	
	GetLocalTime( &system_times );

	m_oSetupDialog.GetRecordPathParameters( path );

	if( m_nDisplayModeNumber == 0x00000000 ) { // LIVE
	
		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDev[ 3 ], psz, 80 );
	}

	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 0 )

	if( m_nDisplayModeNumber == 0x00000001 ) { // RTCB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hFileSourceDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hFileSourceDev[ 3 ], psz, 80 );
	}

	#endif

	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )

	if( m_nDisplayModeNumber == 0x00000001 ) { // RTCB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoDecoderDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDecoderDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDecoderDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDecoderDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoDecoderDev[ 3 ], psz, 80 );
	}

	#endif

	if( m_nDisplayModeNumber == 0x00000002 ) { // RTPB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoMainEncoderDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoMainEncoderDev[ 3 ], psz, 80 );
	}

	if( m_nDisplayModeNumber == 0x00000003 ) { // RTPB

		sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.BMP", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 

		AMESDK_OTHER_SNAPSHOT_BMP( m_hVideoSubEncoderDev[ 0 ], psz );

	//	sprintf( psz, "%sCH01\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
	//	AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoSubEncoderDev[ 0 ], psz, 80 );

		sprintf( psz, "%sCH02\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoSubEncoderDev[ 1 ], psz, 80 );

		sprintf( psz, "%sCH03\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoSubEncoderDev[ 2 ], psz, 80 );

		sprintf( psz, "%sCH04\\%04d%02d%02d%02d%02d%02d.JPG", path, system_times.wYear, system_times.wMonth, system_times.wDay, system_times.wHour, system_times.wMinute, system_times.wSecond ); 
		
		AMESDK_OTHER_SNAPSHOT_JPG( m_hVideoSubEncoderDev[ 3 ], psz, 80 );
	}
	return TRUE;
}

BOOL CSC2A0Dlg::OnApply_SetupDialog()
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] RESET DEVICE RESOURCE
	//
	HwUnInitialize();

	HwInitialize();

	return TRUE;
}

BOOL CSC2A0Dlg::OnFileSourceDestroy_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE FILE SOURCE RESOURCE
	//
	if( m_hFileSourceDev[ nChannelNumber ] != 0xFFFFFFFF ) { 
		
		AMESDK_DESTROY( m_hFileSourceDev[ nChannelNumber ] ); 
		
		m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
	}
	return TRUE;
}

BOOL CSC2A0Dlg::OnFileSourceCreate_FileManagerWindow( ULONG nChannelNumber, AMESDK_FILE_INFO * pFileInfo )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] INITIALIZE FILE SOURCE RESOURCE (PLAYING & PRELOAD)
	//
	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 0 )

		ULONG deinterlace[ 8 ] = { 0, 0, 0, 0, 0, 0, 0, 0 };

		m_oSetupDialog.GetDeinterlaceParameters( deinterlace );

		if( m_hFileSourceDev[ nChannelNumber ] == 0xFFFFFFFF ) {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "Common Analog File Source %s", pFileInfo->m_pszFileName );

			// THE TWO LOCATIONS OF POOL ARE USED TO PLAYING & PRELOAD ALGORITHM
			// 
			m_hFileSourceDev[ nChannelNumber ] = AMESDK_CREATE( psz, nChannelNumber, 2 /*FILE SOURCE*/, m_oChannelWindow_FILE[ nChannelNumber ].m_hWnd, NULL, NULL );

			if( m_hFileSourceDev[ nChannelNumber ] & 0x80000000 ) { 

				m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
			}
			if( pFileInfo->m_nVideoHeight > 288 ) { // 720  480, 720  576, 704  480, 704  576, 640  480, 640  576

			//	AMESDK_SET_DEINTERLACE( m_hFileSourceDev[ nChannelNumber ], deinterlace[ nChannelNumber ] ); // SOFTWARE-BASED DEINTERLACE
			}
			else { // 720  240, 720  288, 704  240, 704  288, 640  240, 640  288, 
				
				   // 360  240, 360  288, 352  240, 352  288, 320  240, 320  288

			//	AMESDK_SET_DEINTERLACE( m_hFileSourceDev[ nChannelNumber ], 0x00000000 ); // SOFTWARE-BASED DEINTERLACE
			}
		}

	#endif

	#if ( SC2A0_RECORD_PLAYBACK_METHOD == 1 )	  

		if( m_hFileSourceDev[ nChannelNumber ] == 0xFFFFFFFF ) {

			CHAR psz[ MAX_PATH ];

			sprintf( psz, "Common Analog File Source %s", pFileInfo->m_pszFileName );

			// THE TWO LOCATIONS OF POOL ARE USED TO PLAYING & PRELOAD ALGORITHM
			// 
			m_hFileSourceDev[ nChannelNumber ] = AMESDK_CREATE( psz, nChannelNumber, 2 /*FILE SOURCE*/, NULL, NULL, NULL );

			if( m_hFileSourceDev[ nChannelNumber ] & 0x80000000 ) { 

				m_hFileSourceDev[ nChannelNumber ] = 0xFFFFFFFF; 
			}
		}

	#endif

	return TRUE;
}

BOOL CSC2A0Dlg::OnFileSourceRun_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_RUN( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC2A0Dlg::OnFileSourcePause_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_PAUSE( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC2A0Dlg::OnFileSourceStop_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STOP( m_hFileSourceDev[ nChannelNumber ] );
}

BOOL CSC2A0Dlg::OnFileSourceStep_FileManagerWindow( ULONG nChannelNumber, ULONG nSteps )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_STEP( m_hFileSourceDev[ nChannelNumber ], nSteps );
}

BOOL CSC2A0Dlg::OnFileSourceGetVideoStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_VIDEO_STREAM_BUFFER( m_hFileSourceDev[ nChannelNumber ], nSample, pStreamBuffer, pStreamBufferSize );
}

BOOL CSC2A0Dlg::OnFileSourceGetAudioStreamBuffer_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, BYTE * pStreamBuffer, ULONG * pStreamBufferSize )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_AUDIO_STREAM_BUFFER( m_hFileSourceDev[ nChannelNumber ], nSample, pStreamBuffer, pStreamBufferSize );
}

BOOL CSC2A0Dlg::OnFileSourceGetVideoStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp, BOOL * pIsKeyFrame )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_VIDEO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp, pIsKeyFrame );
}

BOOL CSC2A0Dlg::OnFileSourceGetAudioStreamData_FileManagerWindow( ULONG nChannelNumber, ULONG nSample, ULONGLONG * pTimeStamp )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_GET_AUDIO_STREAM_DATA( m_hFileSourceDev[ nChannelNumber ], nSample, pTimeStamp );
}

LONGLONG CSC2A0Dlg::OnFileSourceGetMediaLength_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nLength = 0;

	AMESDK_FILE_GET_MEDIA_LENGTH( m_hFileSourceDev[ nChannelNumber ], &nLength, dwTimeUnits );

	return nLength;
}

LONGLONG CSC2A0Dlg::OnFileSourceGetMediaPosition_FileManagerWindow( ULONG nChannelNumber, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	LONGLONG nPosition = 0;

	AMESDK_FILE_GET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], &nPosition, dwTimeUnits );

	return nPosition;
}

BOOL CSC2A0Dlg::OnFileSourceSetMediaPosition_FileManagerWindow( ULONG nChannelNumber, LONGLONG nPosition, DWORD dwTimeUnits )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_POSITION( m_hFileSourceDev[ nChannelNumber ], nPosition, dwTimeUnits );
}

double CSC2A0Dlg::OnFileSourceGetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	double dRate = 0;

	AMESDK_FILE_GET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], &dRate );

	return dRate;
}

BOOL CSC2A0Dlg::OnFileSourceSetMediaPlaybackRate_FileManagerWindow( ULONG nChannelNumber, double dRate )
{
	// [2009.07.20] [HUENGPEI@YUAN.COM.TW] GENERAL FILE SOURCE OPERATION
	//
	return AMESDK_FILE_SET_MEDIA_PLAYBACK_RATE( m_hFileSourceDev[ nChannelNumber ], dRate );
}
