// MyLayout.h: interface for the MyLayout class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_MYLAYOUT_H__51C27F8E_5438_4042_8585_472852B0C3A3__INCLUDED_)
#define AFX_MYLAYOUT_H__51C27F8E_5438_4042_8585_472852B0C3A3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class MyVideoWnd;
class MyViewManager;

class MyLayout  
{
public:
	void MoveVideoWnds();

	void DelAllChannelFromView(int nView);	

	void SetViewManager(MyViewManager* pMgr);

	void SetVideoWnds(MyVideoWnd* listWnd, int nCount);

	void AddChannelToView(int nView,  int nChannelNum);

	void Active();

	void Inactive();

    virtual MyVideoWnd* GetAt(int nPos);

    virtual void SetLayoutRect(RECT &rect);

	void Notify(MyVideoWnd* pVideoWnd);

	void SwapView(MyVideoWnd *pVideoWnd1, MyVideoWnd *pVideoWnd2);

	BOOL IsWinMaximize();

	MyLayout();

	virtual ~MyLayout();

protected:

	virtual void Restore(int nIndex);

	virtual RECT CalcWndPos(int nIndex);

	virtual void ResetWndPos(int nIndex);

	virtual void Maximize(int nIndex);

	CArray<int, int>					m_listViewChannel[ 144 ];

	CArray<MyVideoWnd*, MyVideoWnd*>    m_listWnd;

	CArray<MyVideoWnd*, MyVideoWnd*>    m_listOrginalWnd;
 
    CArray<int, int>					m_listPosState;     // Videow Window mA , O_jέؤojp

	CArray<RECT, RECT>					m_listVideoWndPos;  // Videow Window m

	BOOL m_bIsCompare;
	
	RECT m_Rect;

	RECT m_r1;

	RECT m_r2;

	int  m_nXCount;

	int  m_nYCount;	

	MyViewManager* m_pViewManager;

	enum {WND_NORMAL = 0, WND_MAX = 1, WND_MAX_HIDE = 2};
};

/////////////////////////////////////////////////////////////////////
class My01Layout : public MyLayout
{

public:

	My01Layout();
	~My01Layout();

protected:
	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);
};
/////////////////////////////////////////////////////////////////////
class My04Layout : public MyLayout
{

public:

	My04Layout();
	~My04Layout();

protected:

	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);
};
/////////////////////////////////////////////////////////////////////
class My09Layout : public MyLayout
{

public:

	My09Layout();
	~My09Layout();

protected:

	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);

private:

	int m_nMaxWndIdx;
};
/////////////////////////////////////////////////////////////////////
class My16Layout : public MyLayout
{

public:
	My16Layout();
	~My16Layout();

protected:
	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);
};
/////////////////////////////////////////////////////////////////////
class My36Layout : public MyLayout
{

public:
	My36Layout();
	~My36Layout();

protected:
	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);
};
/////////////////////////////////////////////////////////////////////
class My64Layout : public MyLayout
{

public:
	My64Layout();
	~My64Layout();

protected:
	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);

};
/////////////////////////////////////////////////////////////////////
class My144Layout : public MyLayout
{

public:
	My144Layout();
	~My144Layout();

protected:
	virtual void Restore(int nIndex);
	virtual void Maximize(int nIndex);

};
/////////////////////////////////////////////////////////////////////

#endif // !defined(AFX_YLAYOUT_H__51C27F8E_5438_4042_8585_472852B0C3A3__INCLUDED_)
